// v1.00 of the Simulator

#ifndef SIMULATOR_H
#define SIMULATOR_H

#include <iostream>
#include <vector>
#include <set>
#include "Fleet.h"

using namespace std;

set<int> getUniqueRandomNumbersFromRange(int n, int a, int b);

class LaunchedFleet{ // -- was struct before
public:
    Fleet* fleet;
    int arrivalYear;
    LaunchedFleet();
    LaunchedFleet(Fleet* f, int y);
    bool operator<(LaunchedFleet const &other) const;
    void printArrival();
};

class Planet{
    Fleet* owner;
    int population;
    float growthFactor;
    int lastFleetArrivalYear;
public:
    Planet();
    Fleet* getOwner() const;
    int getPopulation() const;
    int getLastFleetArrivalYear() const;
    void growPopulation(const int year);
    void resolveFleetArrival(Fleet* f);
    void printState() const;
};

class SpaceTravelSimulator{
private:
    Fleet* fleet;
    float alpha;
    float planetDistance; // In light years
    float calcDuration(float dist, int weight);
public:
    SpaceTravelSimulator();
    SpaceTravelSimulator(Fleet* f);
    void alienAttack();
    void diseaseInfection();
    int simulateTravel();   // Executes travel, returns travel duration
    void setAlpha();
};

class Simulator{
private:
    SpaceTravelSimulator spacetravel;
    Planet gaia;
    vector<LaunchedFleet> fleets;
    int year;
    void processAllFleetJourneys();
    void resolveAllFleetArrivals();
public:
    Simulator();
    Simulator(vector<Fleet*> f);
    void addFleet(Fleet* f);
    void launchFleets();
    void report() const;
};

#endif // SIMULATOR_H
